#ifndef _SYSSTATS_CPP
#define _SYSSTATS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>
#include <Psapi.H>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/NewDB.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/SysStats.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND SysStats_hWnd = NULL;
HANDLE SysStats_Thread_Handle;
DWORD SysStats_Thread_ID;
bool bRunSysStatThread = false;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI SysStats_Thread(LPVOID lpData)
{
	char sText[255];
	PROCESS_MEMORY_COUNTERS MyPMC;

	BOOL bResult = FALSE;

	HANDLE hProcess = GetCurrentProcess();

	HWND PageFaults_hWnd         = NULL;
	HWND MemoryUsed_hWnd         = NULL;
	HWND PagedPoolUsage_hWnd     = NULL;
	HWND NPPoolUsage_hWnd        = NULL;
	HWND PageFileUsage_hWnd      = NULL;
	HWND PeakMemUsage_hWnd       = NULL;
	HWND PeakPagedPoolUsage_hWnd = NULL;
	HWND PeakNPPoolUsage_hWnd    = NULL;
	HWND PeakPageFileUsage_hWnd  = NULL;

	memset(&MyPMC, 0, sizeof(MyPMC));

	PageFaults_hWnd         = GetDlgItem(SysStats_hWnd, ID_PAGEFAULTS);
	MemoryUsed_hWnd         = GetDlgItem(SysStats_hWnd, ID_MEMORYUSED);
	PagedPoolUsage_hWnd     = GetDlgItem(SysStats_hWnd, ID_PAGEDPOOLUSAGE);
	NPPoolUsage_hWnd        = GetDlgItem(SysStats_hWnd, ID_NPPOOLUSAGE);
	PageFileUsage_hWnd      = GetDlgItem(SysStats_hWnd, ID_PAGEFILEUSAGE);
	PeakMemUsage_hWnd       = GetDlgItem(SysStats_hWnd, ID_PEAKMEMUSAGE);
	PeakPagedPoolUsage_hWnd = GetDlgItem(SysStats_hWnd, ID_PEAKPAGEDPOOLUSAGE);
	PeakNPPoolUsage_hWnd    = GetDlgItem(SysStats_hWnd, ID_PEAKNPPOOLUSAGE);
	PeakPageFileUsage_hWnd  = GetDlgItem(SysStats_hWnd, ID_PEAKPAGEFILEUSAGE);

	while(bRunSysStatThread)
	{
        bResult = GetProcessMemoryInfo(hProcess, &MyPMC, sizeof(MyPMC));

		FormatInteger(sText, MyPMC.PageFaultCount);
		Set_Text(PageFaults_hWnd, sText);

		FormatInteger(sText, MyPMC.WorkingSetSize / 1024);
		strcat(sText, " KB");
		Set_Text(MemoryUsed_hWnd, sText);

		FormatInteger(sText, MyPMC.QuotaPagedPoolUsage / 1024);
		strcat(sText, " KB");
		Set_Text(PagedPoolUsage_hWnd, sText);

		FormatInteger(sText, MyPMC.QuotaPeakNonPagedPoolUsage / 1024);
		strcat(sText, " KB");
		Set_Text(NPPoolUsage_hWnd, sText);

		FormatInteger(sText, MyPMC.PagefileUsage / 1024);
		strcat(sText, " KB");
		Set_Text(PageFileUsage_hWnd, sText);

		FormatInteger(sText, MyPMC.PeakWorkingSetSize / 1024);
		strcat(sText, " KB");
		Set_Text(PeakMemUsage_hWnd, sText);

		FormatInteger(sText, MyPMC.QuotaPeakPagedPoolUsage / 1024);
		strcat(sText, " KB");
		Set_Text(PeakPagedPoolUsage_hWnd, sText);

		FormatInteger(sText, MyPMC.QuotaPeakNonPagedPoolUsage / 1024);
		strcat(sText, " KB");
		Set_Text(PeakNPPoolUsage_hWnd, sText);

		FormatInteger(sText, MyPMC.PeakPagefileUsage / 1024);
		strcat(sText, " KB");
		Set_Text(PeakPageFileUsage_hWnd, sText);

		Sleep(250);
	}

	//CloseHandle() IS NOT necessary because GetCurrentProcess()
	//	retrieves a pseudo handle for the current process.
	//CloseHandle(hProcess); 

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK SysStatsDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
        SysStats_hWnd = xHandle;

        char sCaption[1024];
		sprintf(sCaption, "%s :: %s", gsTitleCaption, "System Statistics");
		SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON)) );

		bRunSysStatThread = true;
		SysStats_Thread_Handle = CreateThread(NULL, 0, SysStats_Thread, (LPVOID)0, 0, &SysStats_Thread_ID);

		CenterWindow(xHandle);

        return TRUE;
    }

    //--------------------------------------------------------------------------
/*
    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDC_CANCEL)
        {
			EndDialog(xHandle,0);
			DestroyWindow(xHandle);
			return TRUE;
        }
		
		return FALSE;
    }
*/
	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE) 
    {
        bRunSysStatThread = false;
		Sleep(500);
		EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

